<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * GpwType
 *
 * @ORM\Table(name="gpw_types")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\GpwTypeRepository")
 *
 * @ExclusionPolicy("all")
 */
class GpwType
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="symbol", type="string", length=30, unique=true)
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $symbol;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="import_url", type="string", length=255)
     */
    private $importUrl;

    /**
     * @ORM\OneToMany(targetEntity="GpwIndex", mappedBy="type")
     *
     */
    private $indexes;
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->indexes = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return GpwType
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return GpwType
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Add indexes
     *
     * @param \Import\ApiBundle\Entity\GpwIndex $indexes
     * @return GpwType
     */
    public function addIndexe(\Import\ApiBundle\Entity\GpwIndex $indexes)
    {
        $this->indexes[] = $indexes;
    
        return $this;
    }

    /**
     * Remove indexes
     *
     * @param \Import\ApiBundle\Entity\GpwIndex $indexes
     */
    public function removeIndexe(\Import\ApiBundle\Entity\GpwIndex $indexes)
    {
        $this->indexes->removeElement($indexes);
    }

    /**
     * Get indexes
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getIndexes()
    {
        return $this->indexes;
    }

    /**
     * Set importUrl
     *
     * @param string $importUrl
     * @return GpwType
     */
    public function setImportUrl($importUrl)
    {
        $this->importUrl = $importUrl;
    
        return $this;
    }

    /**
     * Get importUrl
     *
     * @return string 
     */
    public function getImportUrl()
    {
        return $this->importUrl;
    }
}